-- MacroScript File
-- Created:       Feb 09 2005
-- Last Modified: Feb 25 2005
-- Medit Utilities
-- Version: 3dsmax 8
-- Author: Alexander Esppeschit Bicalho, Discreet
-- Modified: Alexander Esppeschit Bicalho, Discreet
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Feb 09 - created script
Feb 10 - fixed problem where defaults.ini uses Hex number and ClassID is an Int
Feb 10 - added Restore Medit Slots script
Feb 11 - added Localization Notes
Feb 25 - added Condense Medit
Feb 25 - moved functions to meditfunctions.ms in StdScripts

NOTE TO LOCALIZATION
Only the headers should be localized

*/

macroScript clear_medit_slots 
	category:~CLEAR_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~CLEAR_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~CLEAR_MEDIT_SLOTS_TOOLTIP~
(


on execute do
(
	defaultMtlLibFile = MeditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile
		global _meditMaterialsBeforeReset = #()
		for i in 1 to meditMaterials.count do
		(	
			append _meditMaterialsBeforeReset meditMaterials[i]
			if i <= defaultMtlLib.count then
				meditMaterials[i] = defaultMtlLib[i]
			else
				meditMaterials[i] = defaultMtlLib[defaultMtlLib.count]
		)
	)
)

)

macroScript restore_medit_slots 
	category:~RESTORE_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~RESTORE_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~RESTORE_MEDIT_SLOTS_TOOLTIP~
(

on isEnabled do (if classof _meditMaterialsBeforeReset == Array do _meditMaterialsBeforeReset.count > 0)

on execute do
(
	if _meditMaterialsBeforeReset.count == meditMaterials.count do
	(
		for i in 1 to meditMaterials.count do
		(	
			meditMaterials[i] = _meditMaterialsBeforeReset[i]
		)
		_meditMaterialsBeforeReset = undefined
	)
)

)

macroScript condense_medit_slots 
	category:~CONDENSE_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~CONDENSE_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~CONDENSE_MEDIT_SLOTS_TOOLTIP~
(


on execute do
(
	defaultMtlLibFile = MeditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile

		usedMtls = #()
		for i in 1 to meditMaterials.count do
		(
			if MeditUtilities.isMaterialInUse meditMaterials[i] == true do
				append usedMtls meditMaterials[i]
		)
		global _meditMaterialsBeforeReset = #()
		for i in 1 to meditMaterials.count do
		(	
			append _meditMaterialsBeforeReset meditMaterials[i]
			if i <= usedMtls.count then
				meditMaterials[i] = usedMtls[i]
			else if i <= defaultMtlLib.count then
				meditMaterials[i] = defaultMtlLib[i]
			else
				meditMaterials[i] = defaultMtlLib[defaultMtlLib.count]
		)
	)
)

)

macroScript basic_material_editor
	category:~BASIC_MATERIAL_EDITOR_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~BASIC_MATERIAL_EDITOR_BUTTONTEXT~ 
	tooltip:~BASIC_MATERIAL_EDITOR_TOOLTIP~
(
	on isChecked do
	(
		MatEditor.isOpen() and MatEditor.mode == #basic
	)

	on execute do
	(
		if MatEditor.isOpen() then
		(
			if MatEditor.mode == #advanced then (
				-- this switches the open slate editor into the compact editor
				MatEditor.mode = #basic
			)
			else (
				-- toggle the compact editor
				matEditor.Close()
			)
		)
		else (
			MatEditor.mode = #basic
			matEditor.Open()
		)
	)
)

macroScript advanced_material_editor
	category:~ADVANCED_MATERIAL_EDITOR_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~ADVANCED_MATERIAL_EDITOR_BUTTONTEXT~ 
	tooltip:~ADVANCED_MATERIAL_EDITOR_TOOLTIP~
(

	on isChecked do
	(
		sme.isOpen()
	)

	on execute do
	(
		if MatEditor.isOpen() then
		(
			if MatEditor.mode == #basic then (
				-- this switches the open compact editor into the slate editor
				MatEditor.mode = #advanced
			)
			else (
				-- toggle the slate editor
				sme.Close()
			)
		)
		else (
			MatEditor.mode = #advanced
			sme.Open()
		)
	)
)


macroScript material_create_new_sme
	category:~MATERIAL_CREATE_NEW_SME_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~MATERIAL_CREATE_NEW_SME_BUTTONTEXT~
	tooltip:~MATERIAL_CREATE_NEW_SME_TOOLTIP~
(
	on execute do
	(
		-- TO DO: Is this obsolete?  See stdplugs\stdscripts\meditfunctions.ms
		local newMtl = meditUtilities.getDefaultMaterial undefined

		-- Close Medit
		maxOps.mtlDlgMode = #advanced  -- closes Medit if open and switches to SME

		-- Open SME, or restore the window if minimized
		sme.Open() -- checking sme.IsOpen() is not reliable, it returns true if window is minimized
		
		local nodeViewIndex = sme.activeView
		local nodeView = sme.getView nodeViewIndex
		local nodePos = [0,0]
		nodeView.CreateNode newMtl nodePos
		nodeView.setSelectedNodes #(newMtl)
		nodeView.zoomExtents type:#selected

		sme.SetMtlInParamEditor newMtl
	)
)


macroScript material_edit_selected_sme
	category:~MATERIAL_EDIT_SELECTED_SME_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~MATERIAL_EDIT_SELECTED_SME_BUTTONTEXT~
	tooltip:~MATERIAL_EDIT_SELECTED_SME_TOOLTIP~
(
	on isEnabled do (selection.count==1)

	on execute do
	(
		local editMtl = $.material  -- assume exactly one selected object
		
		if editMtl==undefined do
		(	-- TO DO: Is this obsolete?  See stdplugs\stdscripts\meditfunctions.ms
			editMtl = meditUtilities.getDefaultMaterial undefined
			$.material = editMtl
		)

		-- Close Medit
		maxOps.mtlDlgMode = #advanced  -- closes Medit if open and switches to SME

		-- Open SME, or restore the window if minimized
		sme.Open() -- checking sme.IsOpen() is not reliable, it returns true if window is minimized
		
		local nodeViewIndex = sme.activeView
		local nodeView = sme.getView nodeViewIndex
		local nodePos = [0,0]
		nodeView.CreateNode editMtl nodePos
		nodeView.setSelectedNodes #(editMtl)
		nodeView.zoomExtents type:#selected

		sme.SetMtlInParamEditor editMtl
	)
)
